<?php

namespace  App\Models;

use Illuminate\Database\Eloquent\Model;

class Restaurant extends Model 
{

    protected $table = 'restaurants';
    public $timestamps = true;
    protected $fillable = array('category_id', 'minimum_order', 'delivery_charge', 'phone', 'whats_app', 'image', 'region_id', 'name', 'email', 'password', 'is_active');

    public function region()
    {
        return $this->belongsTo(' App\Models\Region', 'region_id');
    }

    public function categories()
    {
        return $this->belongsToMany(' App\Models\Category', 'category_restaurant');
    }

    public function products()
    {
        return $this->hasMany(' App\Models\Product');
    }

    public function orders()
    {
        return $this->hasMany(' App\Models\Order', 'restaurant_id');
    }

    public function reviews()
    {
        return $this->hasMany(' App\Models\Review', 'restaurant_id');
    }

    public function offers()
    {
        return $this->hasMany(' App\Models\Offer', 'restaurant_id');
    }

    public function paidCommissions()
    {
        return $this->hasMany(' App\Models\PaymentReceive', 'restaurant_id');
    }

}